Imports System.Drawing.Text

Public Class Form1
    Inherits System.Windows.Forms.Form

    Private WithEvents theTimer As Timer
    Private swellValue As Integer
    Private fontFace As String = "WingDings"
    Private installedFonts As String

    ' Pour marquer la police slectionne.
    Private cmiArial As MenuItem = New MenuItem()
    Private cmiTimesNewRoman As MenuItem = New MenuItem()
    Private cmiWingDings As MenuItem = New MenuItem()
    Private cmiFontChecked As MenuItem = New MenuItem()

    Private WithEvents mainMenu As MainMenu
    Private WithEvents mnuFontArial As MenuItem
    Private WithEvents mnuFontTimesNewRoman As MenuItem
    Private WithEvents mnuConfig As MenuItem
    Private WithEvents mnuFileExit As MenuItem
    Private WithEvents mnuConfigFontFace As MenuItem
    Private WithEvents mnuConfigSwell As MenuItem
    Private WithEvents mnuFile As MenuItem
    Private WithEvents mnuConfigShowFonts As MenuItem
    Private WithEvents ListFonts As MenuItem
    Private WithEvents mnuFontWingDings As MenuItem

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'Cet appel est requis par le concepteur Windows Form.
        InitializeComponent()

        'Ajoutez toute initialisation aprs l'appel  InitializeComponent()
        theTimer = New Timer()

        Text = "Application de police"
        Width = 425
        Height = 150
        BackColor = Color.Honeydew
        CenterToScreen()
        theTimer.Enabled = True
        theTimer.Interval = 100

        ' Dfinir la logique de slection du menu police.
        cmiArial = mainMenu.MenuItems(1).MenuItems(1).MenuItems(0)
        cmiTimesNewRoman = mainMenu.MenuItems(1).MenuItems(1).MenuItems(1)
        cmiWingDings = mainMenu.MenuItems(1).MenuItems(1).MenuItems(2)
        cmiFontChecked = cmiWingDings
        cmiFontChecked.Checked = True

    End Sub

    'La classe Form surcharge la mthode dispose pour nettoyer la liste de composants.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Requis par le Concepteur Windows Form
    Private components As System.ComponentModel.Container

    'NOTE: La procdure suivante est requise par le Concepteur Windows Form
    'Elle peut tre modifie en utilisant le Concepteur Windows Form.  
    'Ne pas la modifier en utilisant le Concepteur Windows Form.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.mnuConfigShowFonts = New System.Windows.Forms.MenuItem()
        Me.ListFonts = New System.Windows.Forms.MenuItem()
        Me.mnuConfigFontFace = New System.Windows.Forms.MenuItem()
        Me.mnuFontArial = New System.Windows.Forms.MenuItem()
        Me.mnuFontTimesNewRoman = New System.Windows.Forms.MenuItem()
        Me.mnuFontWingDings = New System.Windows.Forms.MenuItem()
        Me.mnuConfig = New System.Windows.Forms.MenuItem()
        Me.mnuConfigSwell = New System.Windows.Forms.MenuItem()
        Me.mnuFileExit = New System.Windows.Forms.MenuItem()
        Me.mnuFile = New System.Windows.Forms.MenuItem()
        Me.mainMenu = New System.Windows.Forms.MainMenu()
        '
        'mnuConfigShowFonts
        '
        Me.mnuConfigShowFonts.Index = -1
        Me.mnuConfigShowFonts.Text = ""
        '
        'ListFonts
        '
        Me.ListFonts.Index = 2
        Me.ListFonts.Text = "Lister toutes les polices"
        '
        'mnuConfigFontFace
        '
        Me.mnuConfigFontFace.Index = 1
        Me.mnuConfigFontFace.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFontArial, Me.mnuFontTimesNewRoman, Me.mnuFontWingDings})
        Me.mnuConfigFontFace.Text = "Choix de police"
        '
        'mnuFontArial
        '
        Me.mnuFontArial.Index = 0
        Me.mnuFontArial.Text = "&Arial"
        '
        'mnuFontTimesNewRoman
        '
        Me.mnuFontTimesNewRoman.Index = 1
        Me.mnuFontTimesNewRoman.Text = "&Times New Roman"
        '
        'mnuFontWingDings
        '
        Me.mnuFontWingDings.Index = 2
        Me.mnuFontWingDings.Text = "&WingDings"
        '
        'mnuConfig
        '
        Me.mnuConfig.Index = 1
        Me.mnuConfig.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuConfigSwell, Me.mnuConfigFontFace, Me.ListFonts})
        Me.mnuConfig.Text = "Configurer"
        '
        'mnuConfigSwell
        '
        Me.mnuConfigSwell.Index = 0
        Me.mnuConfigSwell.Text = "Grossir?"
        '
        'mnuFileExit
        '
        Me.mnuFileExit.Index = 0
        Me.mnuFileExit.Text = "Sortie"
        '
        'mnuFile
        '
        Me.mnuFile.Index = 0
        Me.mnuFile.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFileExit})
        Me.mnuFile.Text = "Fichier"
        '
        'mainMenu
        '
        Me.mainMenu.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.mnuFile, Me.mnuConfig})
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(292, 253)
        Me.Menu = Me.mainMenu
        Me.Name = "Form1"
        Me.Text = "Form1"

    End Sub

#End Region

    Private Sub Form1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        Dim g As Graphics = e.Graphics
        ' La taille de la police peut tre comprise entre 12 et 62,
        ' base sur la valeur actuelle de swellValue.
        Dim theFont As Font = New Font(fontFace, 12 + swellValue)
        Dim message As String = "Bonjour GDI+"

        ' Afficher un message au centre de la fentre!
        Dim windowCenter As Double = Me.DisplayRectangle.Width / 2
        Dim stringSize As SizeF = e.Graphics.MeasureString(message, theFont)
        Dim startPos As Double = windowCenter - (stringSize.Width / 2)

        g.DrawString(message, theFont, _
         New SolidBrush(Color.Blue), startPos, 10)

        ' Montrer les polices installes.
        Dim myRect As RectangleF = New RectangleF(0, 100, _
         ClientRectangle.Width, ClientRectangle.Height)

        g.FillRectangle(New SolidBrush(Color.Black), myRect)
        g.DrawString(installedFonts, New Font("Arial", 12), _
         New SolidBrush(Color.White), myRect)
    End Sub

    Private Sub theTimer_Tick(ByVal sender As Object, ByVal e As System.EventArgs) Handles theTimer.Tick
        ' Augmenter swellValue de 5 et vrifier
        ' le dbordement.
        swellValue += 5
        If swellValue >= 50 Then
            swellValue = 0
        End If
        'Invalider le plus petit rectangle mal dessin pour rduire le scintillement.
        Invalidate(New Rectangle(0, 0, ClientRectangle.Width, 100))
    End Sub

    Private Sub Form1_Resize(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Resize
        Dim myRect As Rectangle = New Rectangle(0, 100, _
            ClientRectangle.Width, ClientRectangle.Height)
        Invalidate(myRect)
    End Sub

    ' Cette fonction permet de traiter le clic sur les trois polices.
    Private Sub FormatFont_Click(ByVal sender As Object, ByVal e As System.EventArgs) _
      Handles mnuFontArial.Click, mnuFontTimesNewRoman.Click, mnuFontWingDings.Click
        cmiFontChecked.Checked = False

        Dim miClicked As MenuItem = CType(sender, MenuItem)
        fontFace = miClicked.Text.Remove(0, 1)

        If (fontFace = "Arial") Then
            cmiFontChecked = cmiArial
        ElseIf (fontFace = "Times New Roman") Then
            cmiFontChecked = cmiTimesNewRoman
        ElseIf (fontFace = "WingDings") Then
            cmiFontChecked = cmiWingDings
        End If

        cmiFontChecked.Checked = True
        Invalidate()
    End Sub

    Private Sub ListFonts_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListFonts.Click
        Dim fonts As InstalledFontCollection = New InstalledFontCollection()
        Dim i As Integer
        For i = 0 To fonts.Families.Length - 1
            installedFonts += fonts.Families(i).Name & "  "
        Next
        ' Cette fois-ci, il faut invalider la zone cliente complte,
        ' car nous allons dessiner la chane installedFonts dans la moiti basse
        ' du rectangle client.
        Invalidate()
    End Sub

    Private Sub mnuFileExit_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles mnuFileExit.Click
        Me.Close()
    End Sub

    Private Sub mnuConfigSwell_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles mnuConfigSwell.Click
        theTimer.Enabled = Not theTimer.Enabled
        mainMenu.MenuItems(1).MenuItems(0).Checked = theTimer.Enabled
    End Sub

End Class
